import acm.program.*;
import acm.graphics.*;
import javax.swing.*;
import java.awt.event.*;
import java.util.*;
import acm.util.*;

public class InfiniteUndo extends GraphicsProgram {
    
    // Size of each circle, in pixels
    private static final int CIRCLE_DIAM = 50;
    
    // To generate random values for circle positions and colors
    private RandomGenerator rgen = RandomGenerator.getInstance();
    
    // List of circles on screen, from old (0) to new (length - 1)
    private ArrayList<GOval> circlesAdded = new ArrayList<GOval>();
    
    public void init() {
        JButton undoButton = new JButton("Undo");
        add(undoButton, SOUTH);
        JButton randomButton = new JButton("Random");
        add(randomButton, SOUTH);
        
        addActionListeners();
    }
    
    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if (command.equals("Undo")) {
            undo();
        } else if (command.equals("Random")) {
            random();
        }
    }
    
    // Removes the most recent circle from the screen, and our circle list
    private void undo() {
        if (circlesAdded.isEmpty()) return;
        GOval mostRecentCircle = circlesAdded.get(circlesAdded.size() - 1);
        circlesAdded.remove(circlesAdded.size() - 1);
        remove(mostRecentCircle);
        
        // Could also say remove(circlesAdded.remove(circlesAdded.size() - 1));
    }
    
    // Adds a new random circle to the screen, and our circle list
    private void random() {
        int randomX = rgen.nextInt(0, getWidth() - CIRCLE_DIAM);
        int randomY = rgen.nextInt(0, getHeight() - CIRCLE_DIAM);
        GOval circle = new GOval(randomX, randomY, CIRCLE_DIAM, CIRCLE_DIAM);
        circle.setFilled(true);
        circle.setColor(rgen.nextColor());
        add(circle);
        circlesAdded.add(circle);
    }
}
